###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for httpd FEDORA-2007-707
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861345);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-707");
  script_cve_id("CVE-2007-3847", "CVE-2007-4465");
  script_name( "Fedora Update for httpd FEDORA-2007-707");
  desc = "

  Vulnerability Insight:
  The Apache HTTP Server is a powerful, efficient, and extensible
  web server.


  Affected Software/OS:
  httpd on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-September/msg00353.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of httpd");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"httpd", rpm:"httpd~2.2.6~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/httpd-debuginfo", rpm:"x86_64/debug/httpd-debuginfo~2.2.6~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/httpd-manual", rpm:"x86_64/httpd-manual~2.2.6~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/httpd-devel", rpm:"x86_64/httpd-devel~2.2.6~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/mod_ssl", rpm:"x86_64/mod_ssl~2.2.6~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/httpd", rpm:"x86_64/httpd~2.2.6~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/httpd-manual", rpm:"i386/httpd-manual~2.2.6~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/httpd-debuginfo", rpm:"i386/debug/httpd-debuginfo~2.2.6~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/httpd-devel", rpm:"i386/httpd-devel~2.2.6~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/mod_ssl", rpm:"i386/mod_ssl~2.2.6~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/httpd", rpm:"i386/httpd~2.2.6~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}