###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for comix FEDORA-2008-2993
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860810);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-2993");
  script_cve_id("CVE-2008-1568");
  script_name( "Fedora Update for comix FEDORA-2008-2993");
  desc = "

  Vulnerability Insight:
  Comix is a user-friendly, customizable image viewer.
  It is specifically designed to handle comic books, but
  also serves as a generic viewer. It reads images in ZIP,
  RAR or tar archives (also gzip or bzip2 compressed) as
  well as plain image files. It is written in Python and
  uses GTK+ through the PyGTK bindings.


  Affected Software/OS:
  comix on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-April/msg00183.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of comix");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"comix", rpm:"comix~3.6.4~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}