###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for mediawiki FEDORA-2008-8639
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860462);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-8639");
  script_cve_id("CVE-2008-4408");
  script_name( "Fedora Update for mediawiki FEDORA-2008-8639");
  desc = "

  Vulnerability Insight:
  MediaWiki is the software used for Wikipedia and the other Wikimedia
  Foundation websites. Compared to other wikis, it has an excellent
  range of features and support for high-traffic websites using multiple
  servers
  
  This package supports wiki farms. Copy /var/www/wiki over to the
  desired wiki location and configure it through the web
  interface. Remember to remove the config dir after completing the
  configuration.


  Affected Software/OS:
  mediawiki on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-October/msg00179.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mediawiki");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"mediawiki", rpm:"mediawiki~1.13.2~41.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}