###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for grip FEDORA-2008-9521
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860941);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-9521");
  script_cve_id("CVE-2005-0706");
  script_name( "Fedora Update for grip FEDORA-2008-9521");
  desc = "

  Vulnerability Insight:
  Grip is a GTK+ based front-end for CD rippers (such as cdparanoia and
  cdda2wav) and Ogg Vorbis encoders. Grip allows you to rip entire tracks or
  just a section of a track. Grip supports the CDDB protocol for
  accessing track information on disc database servers.


  Affected Software/OS:
  grip on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-November/msg00490.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of grip");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"grip", rpm:"grip~3.2.0~24.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}