###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for pdns-recursor FEDORA-2010-0209
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861603);
  script_version("$Revision: 6414 $: 1.0");
  script_xref(name: "FEDORA", value: "2010-0209");
  script_cve_id("CVE-2009-4009", "CVE-2009-4010");
  script_name("Fedora Update for pdns-recursor FEDORA-2010-0209");
  desc = "

  Vulnerability Insight:
  PowerDNS Recursor is a non authoritative/recursing DNS server. Use this
  package if you need a dns cache for your network.


  Affected Software/OS:
  pdns-recursor on Fedora 11

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2010-January/msg00217.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of pdns-recursor");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC11")
{

  if(isrpmvuln(pkg:"pdns-recursor", rpm:"pdns-recursor~3.1.7.2~1.fc11", rls:"FC11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}