###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for sssd FEDORA-2010-0413
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861625);
  script_version("$Revision: 6862 $: 1.0");
  script_xref(name: "FEDORA", value: "2010-0413");
  script_cve_id("CVE-2010-0014");
  script_name("Fedora Update for sssd FEDORA-2010-0413");
  desc = "

  Vulnerability Insight:
  Provides a set of daemons to manage access to remote directories and
  authentication mechanisms. It provides an NSS and PAM interface toward
  the system and a pluggable backend system to connect to multiple different
  account sources. It is also the basis to provide client auditing and policy
  services for projects like FreeIPA.


  Affected Software/OS:
  sssd on Fedora 12

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-January/033822.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of sssd");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC12")
{

  if(isrpmvuln(pkg:"sssd", rpm:"sssd~1.0.1~1.fc12", rls:"FC12"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}