###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for puppet FEDORA-2010-1372
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861759);
  script_version("$Revision: 6917 $: 1.0");
  script_xref(name: "FEDORA", value: "2010-1372");
  script_cve_id("CVE-2010-0156");
  script_name("Fedora Update for puppet FEDORA-2010-1372");
  desc = "

  Vulnerability Insight:
  Puppet lets you centrally manage every important aspect of your system using a
  cross-platform specification language that manages all the separate elements
  normally aggregated in different files, like users, cron jobs, and hosts,
  along with obviously discrete elements like packages, services, and files.


  Affected Software/OS:
  puppet on Fedora 12

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-March/036166.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of puppet");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC12")
{

  if(isrpmvuln(pkg:"puppet", rpm:"puppet~0.25.4~1.fc12", rls:"FC12"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}