###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ffmpeg_detect_lin.nasl 7204 2010-02-11 15:21:24Z feb $
#
# FFmpeg Version Detection (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800467);
  script_version("$Revision: 6755 $: 1.0");
  script_name("FFmpeg Version Detection (Linux)");
  desc = "
  Overview: This script detects the installed version of FFmpeg and sets the
  result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of FFmpeg");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

paths = find_bin(prog_name:"ffmpeg", sock:sock);
foreach ffmpegbin (paths)
{
  ffmpegVer = get_bin_version(full_prog_name:chomp(ffmpegbin), sock:sock,
                              version_argv:"--version",
                              ver_pattern:"version ([0-9.]+)");
  if(ffmpegVer[1] != NULL)
  {
    set_kb_item(name:"FFmpeg/Linux/Ver", value:ffmpegVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
