###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_js_compiler_code_exec_vuln_win.nasl 3514 2009-07-16 13:45:33Z jul $
#
# Mozilla Firefox JavaScript Compiler Code Execution Vulnerability (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# Upgrade to detect non vulnerable version
#   - By sharaths <sharaths@secpod.com> On 2009-07-17
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800843);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2009-2477");
  script_bugtraq_id(35707);
  script_name("Mozilla Firefox JavaScript Compiler Code Execution Vulnerability (Win)");
  desc = "

  Overview: The host is installed with Mozilla Firefox browser and is prone
  to Remote Code Execution vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an error when processing JavaScript code handling
  'font' HTML tags and can be exploited to cause memory corruption.

  Impact:
  Successful exploitation will let attackers to execute arbitrary code which
  results in memory corruption.

  Impact Level: Application

  Affected Software/OS:
  Firefox version 3.5 and prior on Windows

  Fix: Upgrade to Firefox version 3.5.1 or later
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://secunia.com/advisories/35798
  http://www.milw0rm.com/exploits/9137
  http://www.vupen.com/english/advisories/2009/1868
  http://www.mozilla.org/security/announce/2009/mfsa2009-41.html

  CVSS Score:
    CVSS Base Score     : 6.9 (AV:L/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Win/Ver");
if(!ffVer){
  exit(0);
}

# Grep for Firefox version < 3.5.1
if(version_is_less(version:ffVer, test_version:"3.5.1")){
  security_hole(0);
}
