###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_mult_spoof_vuln_lin_dec09.nasl 6217 2009-12-15 12:48:33Z dec $
#
# Mozilla Firefox Multiple Spoofing Vulnerabilies - dec09 (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801094);
  script_version("$Revision: 6162 $");
  script_cve_id("CVE-2009-4129", "CVE-2009-4130");
  script_bugtraq_id(37230, 37232);
  script_name("Mozilla Firefox Multiple Spoofing Vulnerabilies - dec09 (Linux)");
  desc = "
  Overview: The host is installed with Firefox browser and is prone to multiple
  spoofing vulnerabilies.

  Vulnerability Insight:
  - A race condition error allows attackers to produce a JavaScript message with
    a spoofed domain association by writing the message in between the document
    request and document load for a web page in a different domain.
  - Visual truncation vulnerability in the MakeScriptDialogTitle function in
    nsGlobalWindow.cpp in Mozilla Firefox allows remote attackers to spoof the
    origin domain name of a script via a long name.

  Impact:
  Successful exploitation will let the attackers to conduct spoofing attacks and
  possibly launch further attacks on the system.

  Impact Level:System/Application

  Affected Software/OS:
  Mozilla Firefox version 3.0 to 3.5.5 on Linux.

  Fix:
  No solution or patch is available as on 15th December, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mozilla.com/en-US/firefox/firefox.html

  References:
  http://xforce.iss.net/xforce/xfdb/54612
  http://xforce.iss.net/xforce/xfdb/54611
  http://securitytracker.com/alerts/2009/Dec/1023287.html

  CVSS Score:
    CVSS Base Score       : 5.8 (AV:N/AC:M/Au:NR/C:N/I:P/A:P)
    CVSS Temporal Score   : 4.9
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");
if(!ffVer){
  exit(0);
}

# Grep for Firefox version 3.0 to 3.5.5
if(version_in_range(version:ffVer, test_version:"3.0", test_version2:"3.5.5")){
  security_warning(0);
}
