###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_mult_vuln_jun09_lin.nasl 2940 2009-06-16 12:15:36Z jun $
#
# Mozilla Firefox Multiple Vulnerabilities Jun-09 (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800637);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1832", "CVE-2009-1833", "CVE-2009-1834", "CVE-2009-1835",
                "CVE-2009-1836", "CVE-2009-1837", "CVE-2009-1838", "CVE-2009-1839",
                "CVE-2009-1840", "CVE-2009-1841", "CVE-2009-1392", "CVE-2009-2043",
                "CVE-2009-2044", "CVE-2009-2061", "CVE-2009-2065");
  script_bugtraq_id(35326, 35360, 35280);
  script_name("Mozilla Firefox Multiple Vulnerability Jun-09 (Linux)");
  desc = "

  Overview : The host is installed with Firefox Browser, which is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are reported in Mozilla Firefoz. For more information refer
  to the reference links.

  Impact:
  Successful exploitation could result in remote arbitrary JavaScript code
  execution, spoofing attacks, sensitive information disclosure, and can cause
  denial of service.

  Impact Level: System/Application

  Affected Software/OS:
  Firefox version prior to 3.0.11 on Linux.

  Fix: Upgrade to Firefox version 3.0.11
  http://www.mozilla.com/en-US/firefox/all-older.html

  References :
  http://www.securityfocus.com/archive/1/504214
  http://www.vupen.com/english/advisories/2009/1572
  http://research.microsoft.com/apps/pubs/default.aspx?id=79323
  http://www.mozilla.org/security/announce/2009/mfsa2009-24.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-25.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-26.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-27.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-28.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-29.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-30.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-31.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-32.html
  http://research.microsoft.com/pubs/79323/pbp-final-with-update.pdf

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

firefoxVer = get_kb_item("Firefox/Linux/Ver");
# Check for Fireox version < 3.0.11
if(firefoxVer != NULL)
{
  if(version_is_less(version:firefoxVer ,test_version:"3.0.11")){
    security_hole(0);
  }
}
