###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_mult_vuln_nov09_win.nasl 5567 2009-11-02 11:16:33Z nov $
#
# Mozilla Firefox Multiple Vulnerabilities Nov-09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801130);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1563", "CVE-2009-3370", "CVE-2009-3372", "CVE-2009-3373",
                "CVE-2009-3374", "CVE-2009-3375", "CVE-2009-3376", "CVE-2009-3380");
  script_bugtraq_id(36851, 36853, 36856, 36855, 36857, 36858, 36867, 36871);
  script_name("Mozilla Firefox Multiple Vulnerabilities Nov-09 (Win)");
  desc = "
  Overview: This host is installed with Mozilla Firefox browser and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  Muliple flaw are due to following errors,
  - An array indexing error exists when allocating space for floating point
    numbers. This can be exploited to trigger a memory corruption when a
    specially crafted floating point number is processed.
  - An error in the form history functionality can be exploited to disclose
    history entries via a specially crafted web page that triggers the automatic
    filling of form fields.
  - When parsing regular expressions used in Proxy Auto-configuration. This can
    be exploited to cause a crash or potentially execute arbitrary code via
    specially crafted configured PAC files.
  - When processing GIF, color maps can be exploited to cause a heap based
    buffer overflow and potentially execute arbitrary code via a specially
    crafted GIF file.
  - An error in the 'XPCVariant::VariantDataToJS()' XPCOM utility, which can be
    exploited to execute arbitrary JavaScript code with chrome privileges.
  - An error in the implementation of the JavaScript 'document.getSelection()'
    can be exploited to read text selected on a web page in a different domain.
  - An error when downloading files can be exploited to display different file
    names in the download dialog title bar and download dialog body. This can
    be exploited to obfuscate file names via a right-to-left override character
    and potentially trick a user into running an executable file.
  - Multiple unspecified errors in the browser engines can be exploited to cause
    crash or potentially execute arbitrary code.

  Impact:
  Successful exploitation will let attacker to disclose sensitive information,
  bypass certain security restrictions, manipulate certain data, or compromise
  a user's system.

  Impact Level: Application/System

  Affected Software/OS:
  Firefox version 3.0 before 3.0.15 and 3.5 before 3.5.4 on Windows.

  Fix: Upgrade to Firefox version 3.0.15 or 3.5.4
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://secunia.com/secunia_research/2009-35/
  http://www.mozilla.org/security/announce/2009/mfsa2009-52.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-55.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-56.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-57.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-59.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-61.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-62.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Win/Ver");
if(!ffVer){
  exit(0);
}

# Check for Firefox version 3.0 < 3.0.15 or 3.5 < 3.5.4
if(version_in_range(version:ffVer, test_version:"3.0", test_version2:"3.0.14")||
   version_in_range(version:ffVer, test_version:"3.5", test_version2:"3.5.3")) {
  security_hole(0);
}
