###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_null_ptr_dos_vuln_win.nasl 841 2009-01-12 09:43:33Z jan $
#
# Firefox Browser designMode Null Pointer Dereference DoS Vulnerability - Win
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800405);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0071");
  script_bugtraq_id(33154);
  script_name("Firefox Browser designMode Null Pointer Dereference DoS Vulnerability - Win");
  desc = "

  Overview: The host is installed with Mozilla Firefox browser and is prone to
  denial of service vulnerability.

  Vulnerability Insight:
  Null pointer dereferencing error occurs in the broswer which fails to validate
  the user input data when designMode module is enabled. These can be exploited
  via replaceChild or removeChild call, followed by a queryCommandValue,
  queryCommandState or queryCommandIndeterm call.

  Impact: Successful remote exploitation could result in denying the service.

  Impact Level: Application

  Affected Software/OS:
  Firefox version 3.x to 3.0.5 on Windows.

  Fix: No solution or patch is available as on 13th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://archives.neohapsis.com/archives/fulldisclosure/2009-01/0220.html
  http://archives.neohapsis.com/archives/fulldisclosure/2009-01/0223.html
  http://archives.neohapsis.com/archives/fulldisclosure/2009-01/0224.html

  CVSS Score:
    CVSS Base Score     : 2.6 (AV:N/AC:H/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 2.3
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Win/Ver");
if(!ffVer){
  exit(0);
}

# Grep for firefox version 3.x to 3.0.5
if(version_in_range(version:ffVer, test_version:"3.0", test_version2:"3.0.5")){
  security_warning(0);
}
