###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_url_file_info_dis_vuln.nasl 342 2008-10-17 12:47:33Z oct $
#
# Firefox .url Shortcut File Information Disclosure Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800031);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4582");
  script_bugtraq_id(31747);
  script_name("Firefox .url Shortcut File Information Disclosure Vulnerability");
  desc = "

  Overview: The host is installed with Mozilla Firefox browser, that is prone
  to information disclosure vulnerability.

  Vulnerability Insight:
  The Browser does not properly identify the context of Windows .url shortcut
  files, which allows remote attackers to bypass the Same Origin Policy and
  obtain sensitive information via an HTML document that is directly accessible
  through a filesystem.

  Impact: Successful remote exploitation could result in disclosure of sensitive
  information.

  Impact Level: System

  Affected Software/OS:
  Firefox version 3.0.1 to 3.0.3 on Windows.

  Fix: No solution/patch is available as on 17th October, 2008. Information
  regarding this issue will be updated once the solution details are available.

  References:
  http://liudieyu0.blog124.fc2.com/blog-entry-6.html
  http://www.securityfocus.com/archive/1/archive/1/497091/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.9
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_firefox_detect_win.nasl");
  exit(0);
}


include("version_func.inc");

# Grep for firefox version 3.0.1 to 3.0.3
if(version_in_range(version:get_kb_item("Firefox/Win/Ver"),
                    test_version:"3.0.1", test_version2:"3.0.3")){
  security_warning(0);
}
