###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_flashchat_detect.nasl 2205 2009-05-11 13:52:24Z may $
#
# FlashChat Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800617);
  script_version("Revision: 1.0 ");
  script_name("FlashChat Version Detection");
  desc = "

  Overview: This script detects the installed version of FlashChat and sets the
  result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of FlashChat");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencie("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

flashport = get_http_port(default:80);
if(!flashport){
  exit(0);
}

foreach dir (make_list("/chat","/script","/FlashChat", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:flashport);
  rcvRes = http_send_recv(port:flashport, data:sndReq);
  if(rcvRes != NULL)
  {
    if(("200 OK" >< rcvRes) && ("Welcome to FlashChat" >< rcvRes))
    {
      flashchatVer = eregmatch(pattern:"FlashChat v([0-9.]+)", string:rcvRes);
      if(flashchatVer[1] != NULL){
        set_kb_item(name:"www/" + flashport + "/FlashChat",
                    value:flashchatVer[1] + " under " + dir);
      }
      exit(0);
    }
  }
}
