###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_foxmail_buffer_overflow_vuln.nasl 816 2009-01-07 15:41:24Z jan $
#
# FoxMail Client Buffer Overflow Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800220);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5839");
  script_bugtraq_id(31294);
  script_name("FoxMail Client Buffer Overflow vulnerability");
  desc = "

  Overview: This host is installed with FoxMail Client and is prone to Buffer
  Overflow Vulnerability.

  Vulnerability Insight:
  This flaw is due to lack of sanitization and boundary check in the user
  supplied data which can be exploited by adding a long URL length in the
  HREF attribute of an A element.

  Impact:
  Successful exploitation will let the attacker to insert a long crafted
  URI in the MAILTO field and can cause a stack overflow to the application.

  Impact Level: Application

  Affected Software/OS:
  Foxmail version 6.5 or prior on Windows.

  Fix: No solution or patch is available as on 08th January, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.foxmail.com.cn

  References:
  http://www.sebug.net/exploit/4681
  http://xforce.iss.net/xforce/xfdb/45343

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the Version of Foxmail Client");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_foxmail_detect.nasl");
  exit(0);
}


include("version_func.inc");

fmVer = get_kb_item("Foxmail/Win/Ver");
if(!fmVer){
  exit(0);
}

# Check for Foxmail version 6.5 or prior
if(version_is_less_equal(version:fmVer, test_version:"6.5")){
  security_hole(0);
}
