###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_free_download_mang_detect.nasl 960 2009-02-04 19:19:35Z feb $
#
# Free Download Manager Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800348);
  script_version("Revision: 1.0 ");
  script_name("Free Download Manager Version Detection");
  desc = "
  Overview : This script detects the installed version of Free Download Manager
  and sets the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set Version of Free Download Manager in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

#Check for Free Download Manager and get the installed path
regPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                              "\Uninstall\Free Download Manager_is1",
                          item:"InstallLocation");
if(!regPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:regPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:regPath + "\fdm.exe");

fdmVer = GetVer(share:share, file:file);
if(fdmVer){
  set_kb_item(name:"FreeDownloadManager/Ver", value:fdmVer);
}
