###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_gallery_sec_bypass_vuln.nasl 567 2008-12-04 16:42:16Z dec $
#
# Gallery Unspecified Security Bypass Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800312);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-5296");
  script_bugtraq_id(32440);
  script_name("Gallery Unspecified Security Bypass Vulnerability");
  desc = "

  Overview: The host is running Gallery and is prone to Security Bypass
  Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper validation of authentication cookies.

  Impact:
  Successful exploitation allows attackers to bypass authentication and gain
  administrative access to the application, if register_globals is enabled.

  Impact Level: Application

  Affected Software/OS:
  Gallery Version 1.5.x before 1.5.10 and 1.6 before 1.6-RC3 on all
  platform.

  Fix: Update to version 1.5.10 or 1.6-RC3.
  http://codex.gallery2.org/Downloads

  References:
  http://secunia.com/advisories/32817
  http://xforce.iss.net/xforce/xfdb/46804
  http://gallery.menalto.com/last_official_G1_releases

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Gallery");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach dir (make_list("/gallery", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:port);
  rcvRes = http_keepalive_send_recv(port:port,data:sndReq,bodyonly:1);
  if(rcvRes == NULL){
    exit(0);
  }

  if("Powered by Gallery" >< rcvRes)
  {
    gallVer = eregmatch(pattern:"([0-9.]+)(-[A-Z0-9]+)? -", string:rcvRes);
    gallVer = ereg_replace(pattern:" -", string:gallVer[0], replace:"");
    gallVer = ereg_replace(pattern:"-", string:gallVer, replace:".");

    if(gallVer != NULL)
    {
      # Grep version prior to 1.5.10 and 1.6-RC3
      if(gallVer =~ "^1.5" && version_in_range(version:gallVer,
                                  test_version:"1.5", test_version2:"1.5.9")){
        security_warning(port);
        exit(0);
      }
      if(gallVer =~ "^1.6" && version_in_range(version:gallVer,
                                test_version:"1.6", test_version2:"1.6.RC2")){
        security_warning(port);
        exit(0);
      }
    }
    exit(0);
  }
}
