##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_gdiplus_int_overflow_vuln.nasl 1387 2009-04-02 09:09:37Z mar $
#
# Microsoft GDIPlus Library File Integer Overflow Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800267);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1217");
  script_bugtraq_id(34250);
  script_name("Microsoft GDIPlus Library File Integer Overflow Vulnerability");
  desc = "

  Overview: This host is having GDIPlus Library and is prone to Integer Overflow
  Vulnerability.

  Vulnerability Insight:
  The flaw is in 'GpFont::SetData' Function which has an off-by-one error in the
  gdiplus.dll file.

  Impact:
  Successful exploitation will let the attacker cause application execution
  termination and also denial of service via a crafted EMF File.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft Windows XP Service Pack 2/3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix:
  No solution or patch is available as on 07th April, 2009. Information
  regarding this issue will be updated once the solution are available.
  For further updates refer,
  http://www.microsoft.com/technet/security/advisory/default.mspx

  References:
  http://xforce.iss.net/xforce/xfdb/49438
  http://www.vupen.com/english/advisories/2009/0832
  http://bl4cksecurity.blogspot.com/2009/03/microsoft-gdiplus-emf-gpfontsetdata.html
  http://blogs.technet.com/srd/archive/2009/03/26/new-emf-gdiplus-dll-crash-not-exploitable-for-code-execution.aspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the version of gdiplus.dll");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(hotfix_check_sp(xp:4, win2003:3) <= 0){
  exit(0);
}

getPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                         item:"MediaPath");
if(!getPath){
  exit(0);
}

appendPath = getPath - "Media" + "WinSxS\x86_Microsoft.Windows.GdiPlus" +
                       "_6595b64144ccf1df_1.0.0.0_x-ww_8D353f13\gdiplus.dll";

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:appendPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:appendPath);

gdiVer = GetVer(file:file, share:share);
if(!gdiVer){
  exit(0);
}

# Windows XP
if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 1" >< SP || "Service Pack 2" >< SP || "Service Pack 3" >< SP)
  {
    # Grep for gdiplus.dll <= 5.1.3097.0
    if(version_is_less_equal(version:gdiVer, test_version:"5.1.3097.0")){
       security_hole(0);
    }
  }
  exit(0);
}

# Windows 2003
if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP || "Service Pack 2" >< SP)
  {
    # Grep for gdiplus.dll version <= 5.1.3097.0
    if(version_is_less_equal(version:gdiVer, test_version:"5.1.3097.0")){
       security_hole(0);
    }
  }
}
