###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_google_chrome_dos_vuln.nasl 2133 06-05-2009 14:42:10Z may $
#
# Google Chrome Denial of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800566);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1514");
  script_bugtraq_id(34786);
  script_name("Google Chrome Denial of Service Vulnerability");
  desc = "

  Overview: The host is installed with Google Chrome and is prone to Denial
  of Service vulnerability.

  Vulnerability Insight:
  NULL-pointer deference in browser which causes application crash through a
  throw statement with a long exception value.

  Impact:
  Successful exploitation will let the attacker craft a malicious html file
  and trick the user to open the malicious file which leads to denial of
  service on the affected system.

  Impact level: System

  Affected Software/OS:
  Google Chrome version 1.0.154.53 and prior.

  Fix: No solution or patch is available as on 07th May 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.google.com/chrome

  References:
  http://www.milw0rm.com/exploits/8573
  http://en.securitylab.ru/nvd/378891.php

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(chromeVer == NULL){
  exit(0);
}

if(version_is_less_equal(version:chromeVer, test_version:"1.0.154.53")){
  security_warning(0);
}
