###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_gzip_detect_win.nasl 7064 2010-02-02 19:50:24Z feb $
#
# GZip Version Detection (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800451);
  script_version("$Revision$: 1.0");
  script_name("GZip Version Detection (Win)");
  desc = "
  Overview : This script finds the installed version of GZip and saves
  the version in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set Version of GZip in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\GnuWin32\Gzip")){
  exit(0);
}

key ="SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  gzipName = registry_get_sz(key:key + item, item:"DisplayName");
  if(" Gzip" >< gzipName)
  {
    gzipVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(gzipName != NULL)
    {
      gzipVer = ereg_replace(pattern:"-", string:gzipVer, replace: ".");
       set_kb_item(name:"GZip/Win/Ver", value:gzipVer);
    }
    exit(0);
  }
}
