###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_hp_sim_unauth_access_vuln_win.nasl 350 2008-10-21 11:45:03Z oct $
#
# HP Systems Insight Manager Unauthorized Access Vulnerability (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800033);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4412");
  script_bugtraq_id(31777);
  script_name("HP Systems Insight Manager Unauthorized Access Vulnerability (Win)");
  desc = "

  Overview: This host is running HP Systems Insight Manager (SIM) and is prone
  to security bypass vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an error in the application which allows
  unauthorized access to certain data.

  Impact:
  Successful exploitation could allow remote attackers to gain unauthorized
  access to the data.

  Impact Level: Application

  Affected Software/OS:
  HP SIM prior to 5.2 with Update 2 (C.05.02.02.00) on Windows

  Fix: Update to HP SIM version 5.2 with Update 2 (C.05.02.02.00)
  http://h20392.www2.hp.com/portal/swdepot/index.do

  References:
  http://secunia.com/advisories/32287/
  http://h20000.www2.hp.com/bizsupport/TechSupport/Document.jsp?objectID=c01571962

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of HP SIM");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("http_func.inc");
include("version_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

port = 50000;
if(!port){
  exit(0);
}

if(!get_port_state(port)){
  exit(0);
}

simVer = registry_get_sz(item:"Version",
         key:"SOFTWARE\Hewlett-Packard\Systems Insight Manager\Settings");
if(!simVer){
  exit(0);
}

# Grep for versions prior to 5.2 with update 2 (C.05.02.02.00)
if(version_is_less(version:simVer, test_version:"C.05.02.02.00")){
  security_warning(port);
}
