###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for sendmail HPSBUX02108
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835052);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02108");
  script_cve_id("CVE-2006-0058");
  script_name( "HP-UX Update for sendmail HPSBUX02108");
  desc = "

  Vulnerability Insight:
  A vulnerability has been identified in sendmailwhich may allow a remote 
  attacker to execute arbitrary code. 

  Impact:
  Remote execution of arbitrary code

  Affected Software/OS:
  sendmail on
  HP-UX B.11.23 running sendmail 8.13.3, sendmail 8.11.1 HP-UX B.11.11 running 
  sendmail 8.13.3, sendmail 8.11.1, sendmail 8.9.3 HP-UX B.11.04 running 
  sendmail 8.9.3 HP-UX B.11.00 running sendmail 8.11.1, sendmail 8.9.3, 
  sendmail 8.8.6 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00629555-11

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of sendmail");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"SMAIL-811.INETSVCS-SMAIL", revision:"B.11.00.01.009", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET_29773_1.INETSVCS-RUN", patch_list:['PHNE_35483'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET_29773_2.INETSVCS-RUN", patch_list:['PHNE_35483'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET_29773_3.INETSVCS-RUN", patch_list:['PHNE_35483'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-RUN", patch_list:['PHNE_35483'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET_29773_1.INETSVCS-RUN", patch_list:['PHNE_35483'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET_29773_2.INETSVCS-RUN", patch_list:['PHNE_35483'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET_29773_3.INETSVCS-RUN", patch_list:['PHNE_35483'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-RUN", patch_list:['PHNE_35483'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"SMAIL-UPGRADE.INET-SMAIL", revision:"B.11.11.02.004", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SMAIL-UPGRADE.INET2-SMAIL", revision:"B.11.11.02.004", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SMAIL-UPGRADE.INETSVCS-SMAIL", revision:"B.11.11.02.004", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET31734_1.INETSVCS2-RUN", patch_list:['PHNE_35485'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET31734_3.INETSVCS2-RUN", patch_list:['PHNE_35485'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET31734_4.INETSVCS2-RUN", patch_list:['PHNE_35485'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS2-RUN", patch_list:['PHNE_35485'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"UNOF_INET_29773_1.INETSVCS-RUN", patch_list:['PHNE_34927'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET_29773_2.INETSVCS-RUN", patch_list:['PHNE_34927'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET_29773_3.INETSVCS-RUN", patch_list:['PHNE_34927'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-RUN", patch_list:['PHNE_34927'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"SMAIL-UPGRADE.INET-SMAIL", revision:"B.11.11.02.004", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SMAIL-UPGRADE.INET2-SMAIL", revision:"B.11.11.02.004", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SMAIL-UPGRADE.INETSVCS-SMAIL", revision:"B.11.11.02.004", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SMAIL-811.INETSVCS-SMAIL", revision:"B.11.11.01.010", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET_29774_1.INETSVCS-RUN", patch_list:['PHNE_35484'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET_29774_2.INETSVCS-RUN", patch_list:['PHNE_35484'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"UNOF_INET_29774_3.INETSVCS-RUN", patch_list:['PHNE_35484'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-RUN", patch_list:['PHNE_35484'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
