###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Thunderbird HPSBUX02156
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835179);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02156");
  script_cve_id("");
  script_name( "HP-UX Update for Thunderbird HPSBUX02156");
  desc = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified with Thunderbird 
  running on HP-UX. These vulnerabilities could be exploited remotely 
  resulting in unauthorized access, elevation of privileges, or Denial of 
  Service (DoS). 

  Impact:
  Remote unauthorized access
  elevation of privileges
  Denial of Service (DoS)

  Affected Software/OS:
  Thunderbird on
  Thunderbird email application prior to v2.0.0.9 running on HP-UX B.11.11, 
  B.11.23, and B.11.31. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00774579-4

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Thunderbird");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"Tbird.TBIRD-COM", revision:"2.0.0.9", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"Tbird.TBIRD-COM", revision:"2.0.0.9", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"Tbird.TBIRD-COM", revision:"2.0.0.9", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
