###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Java JRE and JDK HPSBUX02284
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835094);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02284");
  script_cve_id("CVE-2007-5240", "CVE-2007-5239", "CVE-2007-5236", "CVE-2007-5237", "CVE-2007-5238", "CVE-2007-5273", "CVE-2007-5274", "CVE-2007-5232", "CVE-2007-5689");
  script_name( "HP-UX Update for Java JRE and JDK HPSBUX02284");
  desc = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified in Java Runtime 
  Environment (JRE) and Java Developer Kit (JDK) running on HP-UX. These 
  vulnerabilities may allow remote unauthorized access. 

  Impact:
  Remote unauthorized access

  Affected Software/OS:
  Java JRE and JDK on
  HP-UX B.11.11, B.11.23, and B.11.31 running Java Runtime Environment (JRE) 
  v5.0.10 and earlier, and Java Developer Kit (JDK), v1.4.2.16 and earlier. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01234533-4

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Java JRE and JDK");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-COM", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-COM-DOC", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-IPF32", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-PA11", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-COM", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-DEMO", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF32", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF64", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA11", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20W", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PNV2", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PWV2", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM-DOC", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32-HS", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64-HS", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11-HS", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20-HS", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W-HS", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PNV2", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PNV2-H", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PWV2", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PWV2-H", revision:"1.4.2.17.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-COM", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-DEMO", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF32", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF64", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20W", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PNV2", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PWV2", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-COM", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-COM-DOC", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32-HS", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64-HS", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20-HS", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W-HS", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PNV2", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PNV2-H", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PWV2", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PWV2-H", revision:"1.5.0.11", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-COM", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-COM-DOC", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-IPF32", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jpi14.JPI14-PA11", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-COM", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-DEMO", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF32", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF64", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA11", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20W", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PNV2", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PWV2", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM-DOC", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32-HS", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64-HS", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11-HS", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20-HS", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W-HS", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PNV2", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PNV2-H", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PWV2", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PWV2-H", revision:"1.4.2.17.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-COM", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-DEMO", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF32", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF64", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20W", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PNV2", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PWV2", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-COM", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-COM-DOC", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32-HS", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64-HS", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20-HS", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W-HS", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PNV2", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PNV2-H", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PWV2", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PWV2-H", revision:"1.5.0.11", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}