###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for LDAP-UX HPSBUX02330
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835175);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02330");
  script_cve_id("CVE-2008-1659");
  script_name( "HP-UX Update for LDAP-UX HPSBUX02330");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  LDAP-UX. This vulnerability could be exploited to gain local unauthorized 
  access. 

  Impact:
  Local unauthorized access

  Affected Software/OS:
  LDAP-UX on
  HP-UX B.11.11, B.11.23, B.11.31 running LDAP-UX vB.04.10 to vB.04.15. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01447010-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of LDAP-UX");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"LdapUxClient.ADMIN-RUN", revision:"B.04.17", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.CORE-RUN", revision:"B.04.17", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.LDAP-C-SDK", revision:"B.04.17", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.LDUX-ENG-A-MAN", revision:"B.04.17", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.NATIVELDAP-RUN", revision:"B.04.17", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.PAM-AUTHZ-RUN", revision:"B.04.17", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NisLdapServer.YPLDAP-SERVER", revision:"B.04.17", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"LdapUxClient.ADMIN-RUN", revision:"B.04.17", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.CORE-RUN", revision:"B.04.17", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.LDAP-C-SDK", revision:"B.04.17", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.LDUX-ENG-A-MAN", revision:"B.04.17", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.NATIVELDAP-RUN", revision:"B.04.17", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.PAM-AUTHZ-RUN", revision:"B.04.17", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NisLdapServer.YPLDAP-SERVER", revision:"B.04.17", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"LdapUxClient.ADMIN-RUN", revision:"B.04.17", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.CORE-RUN", revision:"B.04.17", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.LDAP-C-SDK", revision:"B.04.17", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.LDUX-ENG-A-MAN", revision:"B.04.17", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.NATIVELDAP-RUN", revision:"B.04.17", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"LdapUxClient.PAM-AUTHZ-RUN", revision:"B.04.17", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NisLdapServer.YPLDAP-SERVER", revision:"B.04.17", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}