###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for IPv6 HPSBUX02407
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835194);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02407");
  script_cve_id("CVE-2008-2476", "CVE-2008-4404");
  script_name( "HP-UX Update for IPv6 HPSBUX02407");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  IPv6. This vulnerability could be exploited remotely resulting in a Denial 
  of Service (DoS) and unauthorized access. 

  Impact:
  Remote Denial of Service (DoS) and unauthorized access

  Affected Software/OS:
  IPv6 on
  HP-UX B.11.11, B.11.23, B.11.31 running IPv6 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01662367-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of IPv6");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"Networking.NET-RUN", patch_list:['PHNE_38680'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"ProgSupport.C-INC", patch_list:['PHNE_38680'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NET-RUN-64", patch_list:['PHNE_38680'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NET2-KRN", patch_list:['PHNE_38680'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NET2-RUN", patch_list:['PHNE_38680'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NMS2-KRN", patch_list:['PHNE_38680'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE2-KRN", patch_list:['PHNE_38680'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.SYS2-ADMIN", patch_list:['PHNE_38680'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"Networking.NET-PRG", patch_list:['PHNE_37897'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NET-RUN", patch_list:['PHNE_37897'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"ProgSupport.C-INC", patch_list:['PHNE_37897'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NET-RUN-64", patch_list:['PHNE_37897'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NET2-KRN", patch_list:['PHNE_37897'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NET2-RUN", patch_list:['PHNE_37897'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NMS2-KRN", patch_list:['PHNE_37897'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE2-KRN", patch_list:['PHNE_37897'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.SYS2-ADMIN", patch_list:['PHNE_37897'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"Networking.NET-KRN", patch_list:['PHNE_37898'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NET-PRG", patch_list:['PHNE_37898'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NET-RUN", patch_list:['PHNE_37898'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NET-RUN-64", patch_list:['PHNE_37898'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE-KRN", patch_list:['PHNE_37898'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"ProgSupport.C-INC", patch_list:['PHNE_37898'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NET2-KRN", patch_list:['PHNE_37898'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Networking.NMS2-KRN", patch_list:['PHNE_37898'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE2-KRN", patch_list:['PHNE_37898'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.SYS-ADMIN", patch_list:['PHNE_37898'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}