###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Java HPSBUX02411
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835195);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02411");
  script_cve_id("CVE-2008-2086", "CVE-2008-5339", "CVE-2008-5340", "CVE-2008-5341", "CVE-2008-5342", "CVE-2008-5343", "CVE-2008-5344", "CVE-2008-5345", "CVE-2008-5347", "CVE-2008-5348", "CVE-2008-5350", "CVE-2008-5351", "CVE-2008-5353", "CVE-2008-5354", "CVE-2008-5356", "CVE-2008-5357", "CVE-2008-5358", "CVE-2008-5359", "CVE-2008-5360");
  script_name( "HP-UX Update for Java HPSBUX02411");
  desc = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified in Java Runtime 
  Environment (JRE) and Java Developer Kit (JDK) running on HP-UX. These 
  vulnerabilities may allow remote unauthorized access, privilege escalation, 
  execution of arbitrary code, and creation of a Denial of Service (DoS) 

  Impact:
  Mulitple remote vulnerabilities

  Affected Software/OS:
  Java on
  HP-UX B.11.11, B.11.23, B.11.31 running HP JDK and JRE 6.0.02 or earlier 
  HP-UX B.11.11, B.11.23, B.11.31 running HP JDK and JRE 5.0.14 or earlier 
  HP-UX B.11.11, B.11.23, B.11.31 running HP Java SDK and RTE 1.4.2.20 or 
  earlier 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01683026-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Java");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-COM", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF32", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF64", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA11", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20W", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32-HS", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64-HS", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11-HS", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20-HS", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W-HS", revision:"1.4.2.21.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-COM", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20W", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF32", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF64", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-COM", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20-HS", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W-HS", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32-HS", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64-HS", revision:"1.5.0.15.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-COM", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-PA20", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-PA20W", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-IPF32", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-IPF64", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-COM", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF32", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF32-HS", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF64", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF64-HS", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20-HS", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20W", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20W-HS", revision:"1.6.0.03.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-COM", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF32", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF64", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA11", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20W", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32-HS", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64-HS", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11-HS", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20-HS", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W-HS", revision:"1.4.2.21.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-COM", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20W", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF32", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF64", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-COM", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20-HS", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W-HS", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32-HS", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64-HS", revision:"1.5.0.15.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-COM", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-PA20", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-PA20W", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-IPF32", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-IPF64", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-COM", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF32", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF32-HS", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF64", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF64-HS", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20-HS", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20W", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20W-HS", revision:"1.6.0.03.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-COM", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF32", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF64", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA11", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20W", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32-HS", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64-HS", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11-HS", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20-HS", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W-HS", revision:"1.4.2.21.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-COM", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20W", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF32", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF64", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-COM", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20-HS", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W-HS", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32-HS", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64-HS", revision:"1.5.0.15.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-COM", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-PA20", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-PA20W", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-IPF32", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-IPF64", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-COM", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF32", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF32-HS", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF64", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF64-HS", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20-HS", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20W", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20W-HS", revision:"1.6.0.03.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
