###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for OpenSSL HPSBUX02418
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835192);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02418");
  script_cve_id("CVE-2008-5077");
  script_name( "HP-UX Update for OpenSSL HPSBUX02418");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  OpenSSL. The vulnerability could be exploited remotely to allow an 
  unauthorized access. 

  Impact:
  Remote unauthorized access

  Affected Software/OS:
  OpenSSL on
  HP-UX B.11.11, B.11.23, B.11.31 running OpenSSL 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01706219-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of OpenSSL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-CONF", revision:"FIPS-OPENSSL-1.1.2.048", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-DOC", revision:"FIPS-OPENSSL-1.1.2.048", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-INC", revision:"FIPS-OPENSSL-1.1.2.048", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-LIB", revision:"FIPS-OPENSSL-1.1.2.048", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-MAN", revision:"FIPS-OPENSSL-1.1.2.048", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-MIS", revision:"FIPS-OPENSSL-1.1.2.048", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-RUN", revision:"FIPS-OPENSSL-1.1.2.048", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-SRC", revision:"FIPS-OPENSSL-1.1.2.048", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-CONF", revision:"FIPS-OPENSSL-1.2.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-DOC", revision:"FIPS-OPENSSL-1.2.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-INC", revision:"FIPS-OPENSSL-1.2.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-LIB", revision:"FIPS-OPENSSL-1.2.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-MAN", revision:"FIPS-OPENSSL-1.2.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-MIS", revision:"FIPS-OPENSSL-1.2.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-RUN", revision:"FIPS-OPENSSL-1.2.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-SRC", revision:"FIPS-OPENSSL-1.2.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-CER", revision:"A.00.09.08j.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-CONF", revision:"A.00.09.08j.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-DOC", revision:"A.00.09.08j.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-INC", revision:"A.00.09.08j.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-LIB", revision:"A.00.09.08j.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-MAN", revision:"A.00.09.08j.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-MIS", revision:"A.00.09.08j.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-PRNG", revision:"A.00.09.08j.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-PVT", revision:"A.00.09.08j.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-RUN", revision:"A.00.09.08j.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-SRC", revision:"A.00.09.08j.003", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-CONF", revision:"FIPS-OPENSSL-1.1.2.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-DOC", revision:"FIPS-OPENSSL-1.1.2.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-INC", revision:"FIPS-OPENSSL-1.1.2.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-LIB", revision:"FIPS-OPENSSL-1.1.2.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-MAN", revision:"FIPS-OPENSSL-1.1.2.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-MIS", revision:"FIPS-OPENSSL-1.1.2.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-RUN", revision:"FIPS-OPENSSL-1.1.2.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-SRC", revision:"FIPS-OPENSSL-1.1.2.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-CONF", revision:"FIPS-OPENSSL-1.2.002", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-DOC", revision:"FIPS-OPENSSL-1.2.002", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-INC", revision:"FIPS-OPENSSL-1.2.002", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-LIB", revision:"FIPS-OPENSSL-1.2.002", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-MAN", revision:"FIPS-OPENSSL-1.2.002", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-MIS", revision:"FIPS-OPENSSL-1.2.002", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-RUN", revision:"FIPS-OPENSSL-1.2.002", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-SRC", revision:"FIPS-OPENSSL-1.2.002", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-CER", revision:"A.00.09.07m.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-CONF", revision:"A.00.09.07m.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-DOC", revision:"A.00.09.07m.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-INC", revision:"A.00.09.07m.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-LIB", revision:"A.00.09.07m.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-MAN", revision:"A.00.09.07m.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-MIS", revision:"A.00.09.07m.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-PRNG", revision:"A.00.09.07m.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-PVT", revision:"A.00.09.07m.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-RUN", revision:"A.00.09.07m.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-SRC", revision:"A.00.09.07m.047", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-CONF", revision:"FIPS-OPENSSL-1.1.2.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-DOC", revision:"FIPS-OPENSSL-1.1.2.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-INC", revision:"FIPS-OPENSSL-1.1.2.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-LIB", revision:"FIPS-OPENSSL-1.1.2.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-MAN", revision:"FIPS-OPENSSL-1.1.2.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-MIS", revision:"FIPS-OPENSSL-1.1.2.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-RUN", revision:"FIPS-OPENSSL-1.1.2.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_1_2.FIPS-SRC", revision:"FIPS-OPENSSL-1.1.2.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-CONF", revision:"FIPS-OPENSSL-1.2.001", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-DOC", revision:"FIPS-OPENSSL-1.2.001", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-INC", revision:"FIPS-OPENSSL-1.2.001", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-LIB", revision:"FIPS-OPENSSL-1.2.001", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-MAN", revision:"FIPS-OPENSSL-1.2.001", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-MIS", revision:"FIPS-OPENSSL-1.2.001", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-RUN", revision:"FIPS-OPENSSL-1.2.001", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"fips_1_2.FIPS-SRC", revision:"FIPS-OPENSSL-1.2.001", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-CER", revision:"A.00.09.07m.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-CONF", revision:"A.00.09.07m.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-DOC", revision:"A.00.09.07m.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-INC", revision:"A.00.09.07m.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-LIB", revision:"A.00.09.07m.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-MAN", revision:"A.00.09.07m.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-MIS", revision:"A.00.09.07m.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-PRNG", revision:"A.00.09.07m.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-PVT", revision:"A.00.09.07m.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-RUN", revision:"A.00.09.07m.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-SRC", revision:"A.00.09.07m.046", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}