###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Apache Web Server Suite HPSBUX02431
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835200);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02431");
  script_cve_id("CVE-2007-4465", "CVE-2008-0005", "CVE-2008-0599", "CVE-2008-2168", "CVE-2008-2371", "CVE-2008-2665", "CVE-2008-2666", "CVE-2008-2829", "CVE-2008-3659", "CVE-2008-3660", "CVE-2008-5498", "CVE-2008-5557", "CVE-2008-5624", "CVE-2008-5625", "CVE-2008-5658");
  script_name("HP-UX Update for Apache Web Server Suite HPSBUX02431");
  desc = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified with HP-UX running 
  Apache-based Web Server or Tomcat-based Servelet Engine. The vulnerabilities 
  could be exploited remotely to cause a Denial of Service (DoS), or execution 
  of arbitrary code. Apache-based Web Server and Tomcat-based Servelet Engine 
  are contained in the Apache Web Server Suite. 

  Impact:
  Remote Denial of Service (DoS)
  execution of arbitrary code

  Affected Software/OS:
  Apache Web Server Suite on
  HP-UX B.11.23 and B.11.31 running Apache-based Web Server v2.2.8.03 or 
  v2.0.59.09 or earlier or Tomcat-based Servelet Engine v5.5.27.01 or earlier 
  HP-UX B.11.11 running Apache-based Web Server v2.0.59.09 or earlier or 
  Tomcat-based Servelet Engine v5.5.27.01 or earlier 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01756421-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Apache Web Server Suite");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.APACHE", revision:"B.2.2.8.04", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.APACHE2", revision:"B.2.2.8.04", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.AUTH_LDAP", revision:"B.2.2.8.04", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.AUTH_LDAP2", revision:"B.2.2.8.04", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.MOD_JK", revision:"B.2.2.8.04", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.MOD_JK2", revision:"B.2.2.8.04", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.MOD_PERL", revision:"B.2.2.8.04", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.MOD_PERL2", revision:"B.2.2.8.04", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.PHP", revision:"B.2.2.8.04", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.PHP2", revision:"B.2.2.8.04", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.WEBPROXY", revision:"B.2.2.8.04", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.WEBPROXY2", revision:"B.2.2.8.04", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22TOMCAT.TOMCAT", revision:"B.2.2.8.04", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.APACHE", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.APACHE2", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.AUTH_LDAP", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.AUTH_LDAP2", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_JK", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_JK2", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_PERL", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_PERL2", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.PHP", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.PHP2", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.WEBPROXY", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE2", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.AUTH_LDAP", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.AUTH_LDAP2", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_JK", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_JK2", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_PERL", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_PERL2", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.PHP", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.PHP2", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.WEBPROXY", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsTOMCAT.TOMCAT", revision:"B.2.0.59.10", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.APACHE", revision:"B.2.2.8.04", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.APACHE2", revision:"B.2.2.8.04", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.AUTH_LDAP", revision:"B.2.2.8.04", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.AUTH_LDAP2", revision:"B.2.2.8.04", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.MOD_JK", revision:"B.2.2.8.04", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.MOD_JK2", revision:"B.2.2.8.04", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.MOD_PERL", revision:"B.2.2.8.04", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.MOD_PERL2", revision:"B.2.2.8.04", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.PHP", revision:"B.2.2.8.04", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.PHP2", revision:"B.2.2.8.04", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.WEBPROXY", revision:"B.2.2.8.04", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.WEBPROXY2", revision:"B.2.2.8.04", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22TOMCAT.TOMCAT", revision:"B.2.2.8.04", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.APACHE", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.APACHE2", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.AUTH_LDAP", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.AUTH_LDAP2", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_JK", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_JK2", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_PERL", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.MOD_PERL2", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.PHP", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.PHP2", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.WEBPROXY", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE2", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.AUTH_LDAP", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.AUTH_LDAP2", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_JK", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_JK2", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_PERL", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_PERL2", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.PHP", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.PHP2", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:".WEBPROXY", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsTOMCAT.TOMCAT", revision:"B.2.0.59.10", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE", revision:"B.2.0.59.10", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE2", revision:"B.2.0.59.10", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.AUTH_LDAP", revision:"B.2.0.59.10", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.AUTH_LDAP2", revision:"B.2.0.59.10", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_JK", revision:"B.2.0.59.10", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_JK2", revision:"B.2.0.59.10", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_PERL", revision:"B.2.0.59.10", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.MOD_PERL2", revision:"B.2.0.59.10", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.PHP", revision:"B.2.0.59.10", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.PHP2", revision:"B.2.0.59.10", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.WEBPROXY", revision:"B.2.0.59.10", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsTOMCAT.TOMCAT", revision:"B.2.0.59.10", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}