###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_httpdx_server_detect.nasl 5290 2009-10-23 14:00:08Z oct $
#
# httpdx Server Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800960);
  script_version("Revision: 1.0");
  script_name("httpdx Server Version Detection");
  desc = "
  Overview : This script detects the version of installed httpdx Server
  and saves the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_summary("Set the version of httpdx Server");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", "Services/ftp", 80, 21);
  exit(0);
}


include("ftp_func.inc");
include("http_func.inc");

httpPort = get_kb_item("Services/www");
if(!httpPort){
  httpPort = 80;
}

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

foreach port (make_list(httpPort, ftpPort))
{
  if(get_port_state(port))
  {
    banner = get_http_banner(port:port);
    if("httpdx" >!< banner){
      banner = get_kb_item(string("Banner/", port));
    }

    if(!isnull(banner) && "httpdx" >< banner)
    {
      httpdxVer = eregmatch(pattern:"httpdx.([0-9.]+[a-z]?)", string:banner);
      if(!isnull(httpdxVer[1])){
        set_kb_item(name:"httpdx/" + port + "/Ver", value:httpdxVer[1]);
      }
    }
  }
}
