###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ibm_db2mc_mult_unspecified_vuln.nasl 4412 2009-09-04 12:11:27Z sep $
#
# DB2 Monitoring Console Multiple Unspecified Security Bypass Vulnerabilities
#
# Authors:
# Antu Sanadi<santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800691);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7130, CVE-2008-7131");
  script_bugtraq_id(28253);
  script_name("DB2 Monitoring Console Multiple Unspecified Security Bypass Vulnerabilities");
  desc = "
  Overview: The host is running IBM DMC and is prone to multiple
  Unspecified Security Bypass Vulnerabilities.

  Vulnerability Insight:
  - An unspecified error can be exploited to upload files to the web
    server hosting the application.
  - An unspecified error can be exploited to gain access to the database
    that a user is currently connected to by tricking the user to access
    malicious link.

  Impact:
  Successful exploitation could allow remote attackers to bypass certain
  security restrictions or potentially compromise a vulnerable system.

  Impact Level: System/Application.

  Affected Software/OS:
  DB2 Monitoring Console Version 2.2.24 and prior.

  Fix: Upgrade to DB2 Monitoring Console Version 2.2.25 or later.
  For updates refer, http://sourceforge.net/projects/db2mc/files/

  References:
  http://secunia.com/advisories/29367
  http://en.securitylab.ru/nvd/384393.php
  http://sourceforge.net/forum/forum.php?forum_id=797405

  CVSS Score:
   CVSS Base Score      : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
   CVSS Temporal Score  : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version DB2 Monitoring Console");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_dependencies("gb_ibm_db2mc_detect.nasl");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

dmcPort = get_http_port(default:80);
if(!dmcPort)
{
  exit(0);
}

dmcVer = get_kb_item("www/" + dmcPort + "/IBM/DB2MC");
if(!dmcVer)
{
   exit(0);
}

dmcVer = eregmatch(pattern:"^(.+) under (/.*)$", string:dmcVer);
if(dmcVer[1] != NULL)
{
  if(version_is_less_equal(version:dmcVer[1], test_version:"2.2.24")){
    security_warning(dmcPort);
  }
}
