###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_irssi_dos_vul_lin.nasl 2747 2009-06-17 15:05:27Z jun $
#
# Irssi Off-by-one Read/Write DoS Vulnerability (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800634);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1959");
  script_bugtraq_id(35399);
  script_name("Irssi Off-by-one Read/Write DoS Vulnerability (Linux)");
  desc = "

  Overview: This host has installed Irssi and is prone to Denial of Service
  Vulnerability

  Vulnerability Insight:
  Off-by-one error in the 'event_wallops' function in fe-common/irc/fe-events.c
  when processing empty commands sent by IRC servers, which triggers a one-byte
  buffer under-read and a one-byte buffer underflow.

  Impact:
  Successful exploitation will let the attackers to cause memory corruption,
  and can crash an affected application by tricking a user into connecting to a
  malicious IRC server.

  Impact Level: Application

  Affected Software/OS:
  Irssi version 0.8.13 and prior on Linux

  Fix: No solution/patch is available as on 17th June, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://irssi.org

  Workaround:
  Apply the patch from below link,
  http://xorl.wordpress.com/2009/05/28/irssi-event_wallops-off-by-one-readwrite

  References:
  http://www.vupen.com/english/advisories/2009/1596
  http://bugs.irssi.org/index.php?do=details&task_id=662
  http://www.securitytracker.com/alerts/2009/Jun/1022410.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Checks for the Version of Irssi");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_irssi_detect_lin.nasl");
  script_require_keys("Irssi/Lin/Ver");
  exit(0);
}


include("version_func.inc");

irssiVer = get_kb_item("Irssi/Lin/Ver");

# Check Irssi version 0.8.13 and prior
if(irssiVer != NULL)
{
  if(version_is_less_equal(version:irssiVer, test_version:"0.8.13")){
    security_warning(0);
  }
}
