##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_kaspersky_av_detect.nasl 1010 2009-02-13 13:10:24Z feb $
#
# Kaspersky AntiVirus Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Updated to detect Kaspersky Internet Security and Anti-Virus for
# Windows File Servers.
# By - Nikita MR <rnikita@secpod.com> on 2010-01-06
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http//intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800241);
  script_version("$Revision: 6354 $: 1.1");
  script_name("Kaspersky AntiVirus Version Detection");
  desc = "
  Overview : This script finds the installed Kaspersky AntiVirus and
  saves the version in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set Version of Kaspersky AntiVirus in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\KasperskyLab")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  prdtName = registry_get_sz(key:key + item, item:"DisplayName");

  if("Kaspersky" >< prdtName)
  {
    # Check for Kaspersky Anti-Virus for Windows Workstations.
    if("Anti-Virus" >< prdtName && "Windows Workstations" >< prdtName)
    {
      kavwVer = registry_get_sz(key:key + item, item:"DisplayVersion");
      if(kavwVer != NULL){
        set_kb_item(name:"Kaspersky/AV-Workstation/Ver", value:kavwVer);
      }
      exit(0);
    }

    # Check for Kaspersky Anti-Virus for Windows File Servers.
    if("Anti-Virus" >< prdtName && "File Servers" >< prdtName)
    {
      kavsVer = registry_get_sz(key:key + item, item:"DisplayVersion");
      if(kavsVer != NULL){
        set_kb_item(name:"Kaspersky/AV-FileServer/Ver", value:kavsVer);
      }
      exit(0);
    }

    # Check for Kaspersky Anti-Virus.
    if(prdtName =~ "Kaspersky Anti-Virus [0-9]+")
    {
      kavVer = registry_get_sz(key:key + item, item:"DisplayVersion");
      if(kavVer != NULL){
        set_kb_item(name:"Kaspersky/AV/Ver", value:kavVer);
      }
      exit(0);
    }

    # Check for Kaspersky Internet Security.
    if("Internet Security" >< prdtName)
    {
      kisVer = registry_get_sz(key:key + item, item:"DisplayVersion");
      if(kisVer != NULL){
        set_kb_item(name:"Kaspersky/IntNetSec/Ver", value:kisVer);
      }
      exit(0);
    }
  }
}
