###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mandriva-theme MDKA-2007:038 (mandriva-theme)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830142);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:038");
  script_cve_id("");
  script_name( "Mandriva Update for mandriva-theme MDKA-2007:038 (mandriva-theme)");
  desc = "

  Vulnerability Insight:

  Some background images were not consistent with the final 2007
  Spring theme.  This update package fixes the Mandriva-1440x900 and
  Mandriva-Powerpack+-1280x800 background images.

  Affected Software/OS:
  mandriva-theme on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-05/msg00016.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mandriva-theme");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"mandriva-theme", rpm:"mandriva-theme~1.2.11~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-theme-Discovery", rpm:"mandriva-theme-Discovery~1.2.11~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-theme-Discovery-screensaver", rpm:"mandriva-theme-Discovery-screensaver~1.2.11~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-theme-Flash", rpm:"mandriva-theme-Flash~1.2.11~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-theme-Flash-screensaver", rpm:"mandriva-theme-Flash-screensaver~1.2.11~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-theme-One", rpm:"mandriva-theme-One~1.2.11~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-theme-One-screensaver", rpm:"mandriva-theme-One-screensaver~1.2.11~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-theme-Powerpack+", rpm:"mandriva-theme-Powerpack+~1.2.11~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-theme-Powerpack+-screensaver", rpm:"mandriva-theme-Powerpack+-screensaver~1.2.11~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-theme-Powerpack", rpm:"mandriva-theme-Powerpack~1.2.11~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-theme-Powerpack-screensaver", rpm:"mandriva-theme-Powerpack-screensaver~1.2.11~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-theme-common", rpm:"mandriva-theme-common~1.2.11~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-theme-screensaver", rpm:"mandriva-theme-screensaver~1.2.11~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}