###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mgetty MDKA-2007:065 (mgetty)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830286);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:065");
  script_cve_id("");
  script_name( "Mandriva Update for mgetty MDKA-2007:065 (mgetty)");
  desc = "

  Vulnerability Insight:

  The /usr/bin/faxspool script in the mgetty-sendfax package, which
  can be used to convert files of various types into a format suitable
  for faxing, attempted to use the 'giftoppm' program to convert .gif
  files. This is a very old program which does not exist in Mandriva
  Linux. This update corrects the script to call the 'giftopnm' program
  instead; this is a more recent program of the same type that exists
  in Mandriva Linux. This will allow the script to convert .gif images
  correctly.

  Affected Software/OS:
  mgetty on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-06/msg00039.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mgetty");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"mgetty", rpm:"mgetty~1.1.30~10.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mgetty-contrib", rpm:"mgetty-contrib~1.1.30~10.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mgetty-sendfax", rpm:"mgetty-sendfax~1.1.30~10.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mgetty-viewfax", rpm:"mgetty-viewfax~1.1.30~10.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mgetty-voice", rpm:"mgetty-voice~1.1.30~10.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"mgetty", rpm:"mgetty~1.1.30~10.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mgetty-contrib", rpm:"mgetty-contrib~1.1.30~10.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mgetty-sendfax", rpm:"mgetty-sendfax~1.1.30~10.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mgetty-viewfax", rpm:"mgetty-viewfax~1.1.30~10.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mgetty-voice", rpm:"mgetty-voice~1.1.30~10.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}