###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for lzma MDVA-2008:012 (lzma)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830634);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:012");
  script_cve_id("");
  script_name( "Mandriva Update for lzma MDVA-2008:012 (lzma)");
  desc = "

  Vulnerability Insight:

  The lzma program did not properly check that the closing of output
  succeeded, which could lead to rare, but possible, data loss.
  Another issue with liblzmadec was also discovered where programs
  could crash if decoding of a stream was not properly initialized.
  
  This update ensures that output is properly closed so as to avoid
  silent data loss, and adds consistency checks to liblzmadec so that
  programs will no longer crash if a stream isn't properly initialized.

  Affected Software/OS:
  lzma on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-01/msg00031.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of lzma");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"dkms-lzma", rpm:"dkms-lzma~4.43~17.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"liblzma0", rpm:"liblzma0~4.43~17.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"liblzma0-devel", rpm:"liblzma0-devel~4.43~17.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lzma", rpm:"lzma~4.43~17.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64lzma0", rpm:"lib64lzma0~4.43~17.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64lzma0-devel", rpm:"lib64lzma0-devel~4.43~17.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}