###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for rpmdrake MDVA-2008:024 (rpmdrake)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830436);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:024");
  script_cve_id("");
  script_name( "Mandriva Update for rpmdrake MDVA-2008:024 (rpmdrake)");
  desc = "

  Vulnerability Insight:

  This update fixes a crash when reading packages with an empty backport
  media (#36720).  This is a rare bug since DVD media did not include
  backport media, and network media provides a non-empty backport media.
  
  It also makes sure that a wait dialog always got destroyed (#36921).
  Due to a bug, in some error cases, the dialog was not destroyed,
  thus blocking the GUI until rpmdrake was closed.
  
  Last but not least, it makes MandrivaUpdate ignore backport media
  tagged as update (#36654).

  Affected Software/OS:
  rpmdrake on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-02/msg00016.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of rpmdrake");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"park-rpmdrake", rpm:"park-rpmdrake~3.117.3~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rpmdrake", rpm:"rpmdrake~3.117.3~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}