###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kdepim MDVA-2008:038 (kdepim)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830375);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:038");
  script_cve_id("");
  script_name( "Mandriva Update for kdepim MDVA-2008:038 (kdepim)");
  desc = "

  Vulnerability Insight:

  When pasting cells from OpenOffice.org to KMail, on Mandriva Linux
  2008.0, KMail would crash.  This update corrects the issue.

  Affected Software/OS:
  kdepim on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-03/msg00021.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdepim");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"kdepim", rpm:"kdepim~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-akregator", rpm:"kdepim-akregator~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-common", rpm:"kdepim-common~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-devel", rpm:"kdepim-devel~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-devel-doc", rpm:"kdepim-devel-doc~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-kaddressbook", rpm:"kdepim-kaddressbook~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-kandy", rpm:"kdepim-kandy~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-karm", rpm:"kdepim-karm~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-kitchensync", rpm:"kdepim-kitchensync~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-kmail", rpm:"kdepim-kmail~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-knode", rpm:"kdepim-knode~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-knotes", rpm:"kdepim-knotes~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-kontact", rpm:"kdepim-kontact~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-korganizer", rpm:"kdepim-korganizer~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-korn", rpm:"kdepim-korn~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-kpilot", rpm:"kdepim-kpilot~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-ktnef", rpm:"kdepim-ktnef~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepim-wizards", rpm:"kdepim-wizards~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdepim2-common", rpm:"libkdepim2-common~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdepim2-index", rpm:"libkdepim2-index~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdepim2-kaddressbook", rpm:"libkdepim2-kaddressbook~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdepim2-kitchensync", rpm:"libkdepim2-kitchensync~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdepim2-kontact", rpm:"libkdepim2-kontact~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdepim2-korganizer", rpm:"libkdepim2-korganizer~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdepim2-kpilot", rpm:"libkdepim2-kpilot~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdepim2-ktnef", rpm:"libkdepim2-ktnef~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdepim2-qopensync", rpm:"libkdepim2-qopensync~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdepim2-common", rpm:"lib64kdepim2-common~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdepim2-index", rpm:"lib64kdepim2-index~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdepim2-kaddressbook", rpm:"lib64kdepim2-kaddressbook~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdepim2-kitchensync", rpm:"lib64kdepim2-kitchensync~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdepim2-kontact", rpm:"lib64kdepim2-kontact~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdepim2-korganizer", rpm:"lib64kdepim2-korganizer~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdepim2-kpilot", rpm:"lib64kdepim2-kpilot~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdepim2-ktnef", rpm:"lib64kdepim2-ktnef~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdepim2-qopensync", rpm:"lib64kdepim2-qopensync~3.5.7~16.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}