###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for x11-driver-video MDVA-2008:048 (x11-driver-video)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830707);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:048");
  script_cve_id("");
  script_name( "Mandriva Update for x11-driver-video MDVA-2008:048 (x11-driver-video)");
  desc = "

  Vulnerability Insight:

  The virtual package x11-driver-video would incorrectly require sparc
  specific video drivers on a x86 architecture computer.
  
  The updated package fixes the issue.

  Affected Software/OS:
  x11-driver-video on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-04/msg00017.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of x11-driver-video");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"x11-driver-video", rpm:"x11-driver-video~1.0.0~13.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}