###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for drakx-kbd-mouse-x11 MDVA-2008:059 (drakx-kbd-mouse-x11)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830438);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:059");
  script_cve_id("");
  script_name( "Mandriva Update for drakx-kbd-mouse-x11 MDVA-2008:059 (drakx-kbd-mouse-x11)");
  desc = "

  Vulnerability Insight:

  An updated XFdrake is available that corrects a number of bugs:
  
  - never write a ModeLine when using the fglrx driver (bug #30934)
  
  - if the EDID gives a valid EISA_ID, a valid 16/10 preferred
  resolution, but no HorizSync/VertRefresh, use a generic flat panel
  HorizSync/VertRefresh (needed for edid.lcd.Elonex-PR600)
  
  - add 800x480 (used on belinea s.book)
  
  - add 1024x600 (used on Samsung Q1Ultra) (bug #37889)
  
  - if the EDID gives a valid 16/10 preferred resolution (even if
  duplicated), but no HorizSync/VertRefresh, use a generic flat panel
  HorizSync/VertRefresh (needed for edid.lcd.dell-inspiron-6400,
  bug #37971)

  Affected Software/OS:
  drakx-kbd-mouse-x11 on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-05/msg00010.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of drakx-kbd-mouse-x11");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"drakx-kbd-mouse-x11", rpm:"drakx-kbd-mouse-x11~0.37.3~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}