###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for gnome-settings-daemon MDVA-2008:077 (gnome-settings-daemon)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830726);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:077");
  script_cve_id("");
  script_name( "Mandriva Update for gnome-settings-daemon MDVA-2008:077 (gnome-settings-daemon)");
  desc = "

  Vulnerability Insight:

  Gnome-settings-daemon was not respecting correctly user settings
  when disabling the background completely. This bug has been sfixed,
  improvement have been made in the time needed to display background
  when nautilus is used by the system, additional bugfixes and
  translations have been integrated in this updated package.

  Affected Software/OS:
  gnome-settings-daemon on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-05/msg00038.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gnome-settings-daemon");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"gnome-settings-daemon", rpm:"gnome-settings-daemon~2.22.1~2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnome-settings-daemon-devel", rpm:"gnome-settings-daemon-devel~2.22.1~2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}