###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for curl MDVA-2008:159 (curl)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830578);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:159");
  script_cve_id("");
  script_name( "Mandriva Update for curl MDVA-2008:159 (curl)");
  desc = "

  Vulnerability Insight:

  An idiosyncratic feature of the Turkish language is that the letter 'i'
  in Turkish is not the lower-case version of the letter 'I'. This issue
  breaks standard POSIX string case comparison on strings containing
  the character 'i'. This issue affected the curl package shipped with
  Mandriva Linux 2009, which ultimately caused it to be incapable of
  handling URIs of the form file:///somefile in Turkish locales. In turn,
  curl is used by webkit, which is used by the Mandriva Linux Control
  Center, ultimately resulting in the Control Center not rendering icons
  in its user interface when run in Turkish locales. The bug likely also
  has other implications for curl-based applications in Turkish locales.
  
  The fixed package includes a fix for this issue, so that curl will
  correctly handle file:///somefile URIs in Turkish locales. As a
  consequence, the Mandriva Linux Control Center now properly renders
  icons in Turkish locales.

  Affected Software/OS:
  curl on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00041.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of curl");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"curl", rpm:"curl~7.19.0~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"curl-examples", rpm:"curl-examples~7.19.0~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcurl4", rpm:"libcurl4~7.19.0~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcurl-devel", rpm:"libcurl-devel~7.19.0~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64curl4", rpm:"lib64curl4~7.19.0~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64curl-devel", rpm:"lib64curl-devel~7.19.0~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}