###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libtool MDVA-2008:167 (libtool)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830615);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:167");
  script_cve_id("");
  script_name( "Mandriva Update for libtool MDVA-2008:167 (libtool)");
  desc = "

  Vulnerability Insight:

  The libtool package shipped with Mandriva Linux 2009 was built with an
  older version of GCC, and was built in a such a way that it depended
  on the specific version of GCC it was built with when linking against
  GCC internals.
  
  The updated package is built with the current GCC in Mandriva Linux
  2009, and has also been changed so it does not depend on a specific
  version of GCC.

  Affected Software/OS:
  libtool on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-11/msg00004.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libtool");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"libltdl3", rpm:"libltdl3~1.5.26~5.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libltdl3-devel", rpm:"libltdl3-devel~1.5.26~5.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtool", rpm:"libtool~1.5.26~5.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtool-base", rpm:"libtool-base~1.5.26~5.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ltdl3", rpm:"lib64ltdl3~1.5.26~5.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ltdl3-devel", rpm:"lib64ltdl3-devel~1.5.26~5.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}