###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kdevelop MDVA-2008:184 (kdevelop)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830464);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:184");
  script_cve_id("");
  script_name( "Mandriva Update for kdevelop MDVA-2008:184 (kdevelop)");
  desc = "

  Vulnerability Insight:

  KDevelop as shipped in Mandriva Linux 2009.0 contains a build time
  bug, which led to subversion support not being correctly compiled.
  As a result, it was not possible to use subversion as the version
  control system for projects in KDevelop.  The updated package fixes
  this problem.

  Affected Software/OS:
  kdevelop on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-11/msg00033.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdevelop");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"kdevelop", rpm:"kdevelop~3.5.3~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdevelop-doc", rpm:"kdevelop-doc~3.5.3~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdevelop3", rpm:"libkdevelop3~3.5.3~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdevelop-devel", rpm:"libkdevelop-devel~3.5.3~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdevelop3", rpm:"lib64kdevelop3~3.5.3~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdevelop-devel", rpm:"lib64kdevelop-devel~3.5.3~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}