###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for apache-conf MDVA-2010:011 (apache-conf)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830791);
  script_version("$Revision: 6414 $: 1.0");
  script_xref(name: "MDVA", value: "2010:011");
  script_name("Mandriva Update for apache-conf MDVA-2010:011 (apache-conf)");
  desc = "

  Vulnerability Insight:

  This is a maintenance and bugfix release of apache-conf that mainly
  fixes so that the httpd service is handled more gracefully when
  reloading the apache server (#56857).
  
  Other fixes (where appliable):
  
  - fix #53887 (obsolete favicon.ico file in Apache default www pages)
  - workaround #47992 (apache does not start occasionally)
  - added logic to make it possible to set limits from the init
  script in an attempt to address #30849 and similar problems
  - added logic to easy debugging with gdb in the initscript
  
  Packages for 2008.0 are provided for Corporate Desktop 2008.0
  customers.

  Affected Software/OS:
  apache-conf on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64,
  Mandriva Linux 2009.1,
  Mandriva Linux 2009.1/X86_64,
  Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64,
  Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00013.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of apache-conf");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"apache-conf", rpm:"apache-conf~2.2.6~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"apache-conf", rpm:"apache-conf~2.2.9~2.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"apache-conf", rpm:"apache-conf~2.2.14~1.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.1")
{

  if(isrpmvuln(pkg:"apache-conf", rpm:"apache-conf~2.2.11~5.2mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"apache-conf", rpm:"apache-conf~2.2.9~2.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}