###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for python-gobject MDVA-2010:022 (python-gobject)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830825);
  script_version("$Revision: 6433 $: 1.0");
  script_xref(name: "MDVA", value: "2010:022");
  script_name("Mandriva Update for python-gobject MDVA-2010:022 (python-gobject)");
  desc = "

  Vulnerability Insight:

  A programming error in the Python bindings for GObject would make
  programs like eliza and Moodvida take up all CPU resources for
  unnecessary operations while running.
  
  This update fixes the problem.

  Affected Software/OS:
  python-gobject on Mandriva Linux 2009.1,
  Mandriva Linux 2009.1/X86_64,
  Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00034.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of python-gobject");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"libpyglib2.0_0", rpm:"libpyglib2.0_0~2.20.0~2.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-gobject", rpm:"python-gobject~2.20.0~2.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-gobject-devel", rpm:"python-gobject-devel~2.20.0~2.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pyglib2.0_0", rpm:"lib64pyglib2.0_0~2.20.0~2.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.1")
{

  if(isrpmvuln(pkg:"libpyglib2.0_0", rpm:"libpyglib2.0_0~2.16.1~3.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-gobject", rpm:"python-gobject~2.16.1~3.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-gobject-devel", rpm:"python-gobject-devel~2.16.1~3.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pyglib2.0_0", rpm:"lib64pyglib2.0_0~2.16.1~3.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}