###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mkinitrd MDVA-2010:032 (mkinitrd)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830810);
  script_version("$Revision: 6433 $: 1.0");
  script_xref(name: "MDVA", value: "2010:032");
  script_name("Mandriva Update for mkinitrd MDVA-2010:032 (mkinitrd)");
  desc = "

  Vulnerability Insight:

  When a system uses dmraid, mkinitrd now calls dmraid command with the
  option --rm_partitions. This option is only available in new dmraid
  package, so boot will fail if, during an upgrade, initrd is generated
  with new mkinitrd and old dmraid (#55427). This updated package adds
  this dependency.
  
  Additionally, two bug were fixed about drm modules inclusion
  (#55676). First, when a drm module was loaded at the time mkinitrd
  is run, it would be included even if it not in DRM_WHITELIST. Then,
  when a module was whitelisted, all the drm modules for this hardware
  where included, including proprietary ones).

  Affected Software/OS:
  mkinitrd on Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00050.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mkinitrd");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"libbdevid-python", rpm:"libbdevid-python~6.0.93~6.2mnb2", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mkinitrd", rpm:"mkinitrd~6.0.93~6.2mnb2", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mkinitrd-devel", rpm:"mkinitrd-devel~6.0.93~6.2mnb2", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nash", rpm:"nash~6.0.93~6.2mnb2", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}