###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for gnupg2 MDVA-2010:033 (gnupg2)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830829);
  script_version("$Revision: 6461 $: 1.0");
  script_xref(name: "MDVA", value: "2010:033");
  script_name("Mandriva Update for gnupg2 MDVA-2010:033 (gnupg2)");
  desc = "

  Vulnerability Insight:

  A packaging mistake lead to that the gpg-agent was not started by
  default. The updated packages addresses this problem.

  Affected Software/OS:
  gnupg2 on Mandriva Linux 2009.1,
  Mandriva Linux 2009.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00054.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gnupg2");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.1")
{

  if(isrpmvuln(pkg:"gnupg2", rpm:"gnupg2~2.0.11~1.3mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}