###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libxrender MDVA-2010:038 (libxrender)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830838);
  script_version("$Revision: 6485 $: 1.0");
  script_xref(name: "MDVA", value: "2010:038");
  script_name("Mandriva Update for libxrender MDVA-2010:038 (libxrender)");
  desc = "

  Vulnerability Insight:

  The libxrender library contained a bug where it could crash
  applications on x86_64 bit machines when the XRenderSetPictureFilter
  function was called (#56721).

  Affected Software/OS:
  libxrender on Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00068.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libxrender");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"libxrender1", rpm:"libxrender1~0.9.4~5.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxrender1-devel", rpm:"libxrender1-devel~0.9.4~5.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxrender1-static-devel", rpm:"libxrender1-static-devel~0.9.4~5.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxrender", rpm:"libxrender~0.9.4~5.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xrender1", rpm:"lib64xrender1~0.9.4~5.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xrender1-devel", rpm:"lib64xrender1-devel~0.9.4~5.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xrender1-static-devel", rpm:"lib64xrender1-static-devel~0.9.4~5.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}